<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright 2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

if (!class_exists('vB_DataManager', false))
{
	exit;
}

/**
* Class to do data save/delete operations for Feedbacks
*
* @package	Forumon
*/
class vBMail_DataManager_Feedback extends vB_DataManager
{
	/**
	* Array of recognised and required fields for feedbacks, and their types
	*
	* @var	array
	*/
	var $validfields = array(
		'feedbackid' 		=> array(TYPE_UINT, 	REQ_INCR, 	VF_METHOD, 	'verify_nonzero'),
		'title' 			=> array(TYPE_STR, 		REQ_YES),
		'description' 		=> array(TYPE_STR, 		REQ_NO),
		'active' 			=> array(TYPE_UINT, 	REQ_NO, 	VF_METHOD),
		'displayorder' 		=> array(TYPE_UINT, 	REQ_NO),
	);

	/**
	* Array of field names that are bitfields, together with the name of the variable in the registry with the definitions.
	*
	* @var	array
	*/
	//var $bitfields = array('adminpermissions' => 'bf_ugp_adminpermissions');

	/**
	* The main table this class deals with
	*
	* @var	string
	*/
	var $table = 'dbtech_vbmail_feedback';

	/**
	* Condition for update query
	*
	* @var	array
	*/
	var $condition_construct = array('feedbackid = %1$d', 'feedbackid');

	/**
	* Constructor - checks that the registry object has been passed correctly.
	*
	* @param	vB_Registry	Instance of the vBulletin data registry object - expected to have the database object as one of its $this->db member.
	* @param	integer		One of the ERRTYPE_x constants
	*/
	function vBMail_DataManager_Feedback(&$registry, $errtype = ERRTYPE_STANDARD)
	{
		parent::vB_DataManager($registry, $errtype);

		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_feedbackdata_start')) ? eval($hook) : false;
	}

	/**
	* Verifies that the active flag is valid
	*
	* @param	string	Active flag
	*
	* @return	boolean
	*/
	function verify_active(&$active)
	{
		// Validate active
		$active = (!in_array($active, array(0, 1)) ? 1 : $active);
		
		return true;
	}	

	/**
	* Any checks to run immediately before saving. If returning false, the save will not take place.
	*
	* @param	boolean	Do the query?
	*
	* @return	boolean	True on success; false if an error occurred
	*/
	function pre_save($doquery = true)
	{
		if ($this->presave_called !== null)
		{
			return $this->presave_called;
		}
		
		$return_value = true;
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_feedbackdata_presave')) ? eval($hook) : false;

		$this->presave_called = $return_value;
		return $return_value;
	}

	/**
	* Additional data to update after a save call (such as denormalized values in other tables).
	* In batch updates, is executed for each record updated.
	*
	* @param	boolean	Do the query?
	*/
	function post_save_each($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_feedbackdata_postsave')) ? eval($hook) : false;
		
		// Rebuild the cache
		VBMAIL_CACHE::build('feedback');
		
		// Ensure we can do language verifications
		require_once(DIR . '/includes/adminfunctions_language.php');

		/*insert query*/
		$this->dbobject->query_write("
			REPLACE INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product, username, dateline, version)
			VALUES
				(-1,
				'dbtech_vbmail_unsubscribefeedback_" . $this->fetch_field('feedbackid') . "_title',
				'" . $this->dbobject->escape_string($this->fetch_field('title')) . "',
				'global',
				'dbtech_vbmail',
				'Admin',
				" . TIMENOW . ",
				'1.0.0')
		");

		/*insert query*/
		$this->dbobject->query_write("
			REPLACE INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product, username, dateline, version)
			VALUES
				(-1,
				'dbtech_vbmail_unsubscribefeedback_" . $this->fetch_field('feedbackid') . "_description',
				'" . $this->dbobject->escape_string($this->fetch_field('description')) . "',
				'global',
				'dbtech_vbmail',
				'Admin',
				" . TIMENOW . ",
				'1.0.0')
		");
		
		// Rebuild the language
		build_language(-1);

		return true;
	}

	/**
	* Additional data to update after a delete call (such as denormalized values in other tables).
	*
	* @param	boolean	Do the query?
	*/
	function post_delete($doquery = true)
	{
		($hook = vBulletinHook::fetch_hook('dbtech_vbmail_feedbackdata_delete')) ? eval($hook) : false;
		
		// Rebuild the cache
		VBMAIL_CACHE::build('feedback');
		
		return true;
	}
}